% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{plot.GroupedFrequencyTable}
\alias{plot.GroupedFrequencyTable}
\title{Gerenic plot of the GroupedFrequencyTable}
\usage{
\method{plot}{GroupedFrequencyTable}(
  x,
  group_names = NULL,
  strict_names = TRUE,
  plot_grid = is.intersected(x),
  ...
)
}
\arguments{
\item{x}{A \code{GroupedFrequencyTable} object}

\item{group_names}{vector specifying which groups should appear in the plots}

\item{strict_names}{If \code{TRUE}, then intersected groups are filtered
using \emph{strict} strategy: \code{group_names} need to be provided in form: \code{"group1:group2"}. If
\code{FALSE}, then intersected groups will be taken into regard separately, so
eg. when \code{"group1"} is provided to \code{group_names}, all of: \code{"group1:group2"},
\code{"group1:group3"}, \code{"group1:groupN"}  will be plotted. Defaults to \code{TRUE}}

\item{plot_grid}{boolean indicating if the \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} should be used.
If \code{FALSE}, then \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} is used. If groups are not intersected,
then it will be ignored and \code{facet_wrap} will be used.}

\item{...}{named list of additional arguments passed to \code{facet} function
used.}
}
\description{
Generic plot using \code{ggplot2}. It plots FrequencyTables for all
groups by default, or only chosen ones using when \code{group_names} argument is specified.
}
