% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{findROC}
\alias{findROC}
\title{Compute the area under the ROC curve}
\usage{
findROC(Data, coeff)
}
\arguments{
\item{Data}{a data matrix; in the first column there should be the binary response variable y.
If you give the training dataset it will calculate the in-sample AUC.
If supplied with a new dataset then it will return the predictive AUC.}

\item{coeff}{vector of coefficients}
}
\value{
The area under the ROC curve, the sensitivity and specificity
}
\description{
This function computes the numeric value of area under the ROC curve (AUC) with the trapezoidal rule.
It is a wrapper function around the pRoc function in the roc package
}
\examples{
\dontrun{
set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise   <- 5
simData <- SimData(N=100,beta=beta, noise=noise, corr=FALSE)

stepPenal<- StepPenal(Data=simData, lamda=1.2, w=0.7)

(coeffP <- stepPenal$coeffP)

findROC(simData, coeff=coeffP)
}
}
\seealso{
\code{\link[pROC]{roc}}
}
