% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaanSummary.R
\name{lavaanSummary}
\alias{lavaanSummary}
\title{Outputs Lavaan Summary}
\usage{
lavaanSummary(x, subset = NULL)
}
\arguments{
\item{x}{a stim Object}

\item{subset}{Specify which model(s) you would like summarized. Default is to output all estimated models}
}
\value{
Lavaan summary table
}
\description{
Outputs Lavaan Summary
}
\examples{
model <- 'Y~X'
stability <- data.frame(X = c(.3, .4, .5), Y = c(.3, .5, .6))
dat <- data.frame(Y = rnorm(500, 0, 1), X = rnorm(500, 0, 1), Z = rnorm(500, 0, 1))

output <- stim(data = dat, model = model, stability = stability)

lavaanSummary(output, subset = c(1,2))
}
