% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelImpliedEq.R
\name{modelImpliedEq}
\alias{modelImpliedEq}
\title{Get the model implied symbolic equations for the auto-regressive effects and
the covariances between the phantom variables}
\usage{
modelImpliedEq(S, blueprint, stability, residualcov)
}
\arguments{
\item{S}{Sample covariance matrix}

\item{blueprint}{A character matrix that specifies which effects to estimate and
which effects to constrain to a non-zero value}

\item{stability}{A named object that contains stability information for each
variable in the model.}

\item{residualcov}{A list with both the lavaan syntax for the residual covariance
and a dataframe with the variable names}
}
\value{
A list of 1) A character vector with the model implied equations for the autoregressive
effects and the phantom variable covariances, and 2) the symbolic psi and covariance
matrices that were used to get the model implied equations.
}
\description{
Get the model implied symbolic equations for the auto-regressive effects and
the covariances between the phantom variables
}
\keyword{internal}
