% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stim.R
\name{summary.stim}
\alias{summary.stim}
\title{Summary method for \code{stim} objects}
\usage{
\method{summary}{stim}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stim}}

\item{...}{Not used}
}
\value{
A print out containing the results for a set of Stability Informed Models
}
\description{
Summarize a set of Stability Informed Models
}
\examples{
\donttest{
model <- 'Y~X'
stability <- data.frame(X = .3, Y = .3)
dat <- data.frame(Y = rnorm(500, 0, 1), X = rnorm(500, 0, 1))

modelFit <- stim(data = dat, model = model, stability = stability)

summary(modelFit)
}

}
\seealso{
\code{\link{stim}}
}
