% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fhd_rotor.R
\name{get_fhd_rotor}
\alias{get_fhd_rotor}
\title{Returns the proportion of birds at height bands along the rotor}
\usage{
get_fhd_rotor(hub_height, fhd, rotor_radius, tidal_offset, yinc = 0.05)
}
\arguments{
\item{hub_height}{A numeric value, the height of the rotor hub (\eqn{H}), given by the
sum of rotor radius and minimum blade clearance above the highest
astronomical tide (HAT), in metres.}

\item{fhd}{A numeric vector, the proportion of bird flights per-1 metre
height bands from sea surface, starting from 0-1 metre band.}

\item{rotor_radius}{A numeric value, the radius of the rotor (\eqn{R}), in
metres.}

\item{tidal_offset}{A numeric value, the tidal offset, the difference between
HAT and mean sea level, in metres.}

\item{yinc}{A numeric value, the increment for height bands between the
lowest and highest points of the rotor, expressed as a proportion of rotor
radius (defaults is 0.05).}
}
\value{
A numeric vector, the flight height distribution at collision risk,
i.e. between minimum and maximum rotor height.
}
\description{
Derive the expected proportion of bird flights at equidistant
height bands between the lowest and highest points of the rotor. In other
words, returns the flight height distribution at collision risk
(\eqn{d(y)}).
}
\examples{

 gen_fhd_dat <- Johnston_Flight_heights_SOSS \%>\%
       dplyr::filter(variable=="Gannet.est") \%>\%
       dplyr::select(height,prop)
 if(is.data.frame(gen_fhd_dat)) gen_fhd <- gen_fhd_dat$prop

 get_fhd_rotor(
   hub_height = 150,
   fhd = gen_fhd,
   rotor_radius = 120,
   tidal_offset = 2.5,
   yinc = 0.05)

}
