% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler_hd.R
\name{sampler_hd}
\alias{sampler_hd}
\title{Customised sampling function wrapper}
\usage{
sampler_hd(
  dat,
  mode = "rtnorm",
  n = NULL,
  mean = NULL,
  sd = NULL,
  lower = 0,
  upper = NULL
)
}
\arguments{
\item{dat}{= A decimal value. The SD value to test (from the UI) - if not available in the UI, then do not create a distribution}

\item{mode}{= A string.  Either 'rtnorm', 'rbeta' or 'rnorm' to determine which distribution to generate}

\item{n}{An integer value. The number of samples to generate}

\item{mean}{A decimal value. The mean for the truncated normal distribution}

\item{sd}{A decimal value. The standard deviation of the distribution to simulate}

\item{lower}{A decimal value. The lower limit for the distribution}

\item{upper}{A decimal value. The upper limit for the distribution}
}
\value{
a vector of samples values from the distribution
}
\description{
Samples a dataset based on inputs for either the rtnorm, rbeta or 'rnorm' distributions
}
\examples{
  sampler_hd(dat=0.1,
       mode='rtnorm',
       n=100,
       mean=9,
       sd=0.1)

}
