% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.localdiag.R
\name{print.localdiag}
\alias{print.localdiag}
\title{Print of the diagnostics' result on a spatio-temporal  point process model}
\usage{
\method{print}{localdiag}(x, ...)
}
\arguments{
\item{x}{A \code{localdiag} object}

\item{...}{additional unused argument}
}
\description{
It prints the main information on the result of the local diagnostics
 performed with \link{localdiag} on either a \code{stp} or \code{stlp} object:
 whether the local test was run on point patterns lying on a linear network or not;
 the number of points in the analysed spatio-temporal
 point pattern \code{X};
 the number of points of \code{X} which are identified as outlying by the
 previously performed local diagnostics.
}
\examples{

set.seed(2)
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(.3, 6))

mod1 <- stppm(inh, formula = ~ 1)

resmod1 <- localdiag(inh, mod1$l, p = .9)

resmod1



}
\references{
Adelfio, G., Siino, M., Mateu, J., and Rodríguez-Cortés, F. J. (2020). Some properties of local weighted second-order statistics for spatio-temporal point processes. Stochastic Environmental Research and Risk Assessment, 34(1), 149-168.

D’Angelo, N., Adelfio, G.  and Mateu, J. (2022) Local inhomogeneous second-order characteristics for spatio-temporal point processes on linear networks. Stat Papers. https://doi.org/10.1007/s00362-022-01338-4
}
\seealso{
\link{infl}, \link{plot.localdiag}, \link{summary.localdiag}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
