% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_tite_data.R
\name{sim_tite_data}
\alias{sim_tite_data}
\title{Simulate time-to-event data for safety monitoring under Weibull distribution or power family (TITE Method)}
\usage{
sim_tite_data(n, p, tau, A, family, s)
}
\arguments{
\item{n}{Sample size}

\item{p}{Vector of cumulative incidence probabilities at time \code{tau} for all causes (length 1 for survival, 2 for competing risks)}

\item{tau}{Length of observation period}

\item{A}{Length of accrual period}

\item{family}{Event time distribution, choices including Weibull distribution ('weibull'), or power family ('power')}

\item{s}{Shape parameter for Weibull distribution or power parameter for power family}
}
\value{
A matrix with three columns: patient enrollment time, event time, and event indicator
}
\description{
Simulate time-to-event data for safety monitoring under Weibull distribution or power family (TITE Method)
}
\section{Functions}{
\itemize{
\item \code{sim_tite_data()}: function to simulate time-to-event data from either Weibull or power family distribution for evaluating safety
monitoring rules. A random sample of size \code{n} is generated from a Weibull
distribution with shape parameter \code{s} or power family distribution with power parameter \code{s} to attain a toxicity rate matching the first element of \code{p} at
event time \code{tau}. Enrollment times are also simulated over an accrual period
of duration \code{A} under a uniform (0,\code{A}) distribution.

}}
