% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtrials.tite.R
\name{simtrials.tite}
\alias{simtrials.tite}
\title{Simulate trials with safety monitoring by the TITE method}
\usage{
simtrials.tite(rule, p, tau, MC, A, family, s)
}
\arguments{
\item{rule}{A \code{rule.tite} object with the safety stopping rule for evaluation}

\item{p}{Vector of cumulative incidence probabilities at time \code{tau} for all causes (length 1 for survival, 2 for competing risks)}

\item{tau}{Length of observation period}

\item{MC}{Number of Monte Carlo replicated datasets to simulate}

\item{A}{Length of accrual period}

\item{family}{Event time distribution, choices including Weibull distribution ('weibull') and power family ('power')}

\item{s}{Shape parameter for Weibull distribution or power parameter for power family}
}
\value{
A matrix with \code{MC} rows and 14 columns, one row per simulated
        trial. Columns include the stopping rule type and design parameters,
        the numbers of events and enrolled patients, the total follow-up time
        in the cohort, the calendar time when the study ends, the reject/no reject
        decision, and the last stage of monitoring reached when the study ends.
}
\description{
Internal workhorse function used to simulate trials with safety monitoring by
the TITE method. The provided stopping \code{rule} is used for
monitoring of \code{MC} simulated trials. For each trial, a random sample is
generated from either a Weibull distribution with shape parameter \code{s} or
power distribution with power parameter to attain a toxicity rate of
\code{p}. Enrollment times are simulated over an accrual
period of duration \code{A} under a uniform (0,\code{A}) distribution.
}
\examples{
\dontrun{
set.seed(2025)
}
}
