% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposal_info.R
\name{delete_proposal}
\alias{delete_proposal}
\title{Delete Proposal}
\usage{
delete_proposal(proposal_name)
}
\arguments{
\item{proposal_name}{A string specifying the name of the proposal to be deleted.}
}
\value{
If \code{proposal_name} does not exist, the function returns an error message. If the proposal exists and is successfully deleted, a message confirming its successful removal will be displayed.
}
\description{
This function deletes a proposal that was previously stored by the user using the \code{save_proposal()} function. It is useful for managing stored proposals and freeing up space.
}
\examples{
# First, let's create a proposal to sample from a standard normal distribution
f_normal <- function(x) { 0.3989423 * exp(-0.5 * x^2) }
normal_proposal = build_proposal(f = f_normal, modes = 0, lower = -Inf, upper = Inf, steps = 1000)
print(normal_proposal)

# Then, save this proposal in R's internal data directory using
# `save_proposal()` with the name "normal"
save_proposal(normal_proposal, "normal")

# Now, we can print all proposals stored on this machine using `print_proposals()`
print_proposals()

# The list will include the `normal_proposal` stored under the name "normal"

# To delete the "normal" proposal from the machine, pass its name to `delete_proposal`
delete_proposal("normal")

# Now, when we print all stored proposals, the "normal" proposal will no longer be listed
print_proposals()

}
