% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srpareto.R
\name{srpareto_optimize}
\alias{srpareto_optimize}
\title{Optimizing Pareto Distribution proposal}
\usage{
srpareto_optimize(
  scale = NULL,
  shape = NULL,
  xl = NULL,
  xr = NULL,
  steps = 4091,
  proposal_range = NULL,
  theta = 0.1,
  target_sample_size = 1000,
  verbose = FALSE
)
}
\arguments{
\item{scale}{(optional) Numeric. scale parameter of the Pareto Distribution. Defaults to \code{NULL}, which implies a scalable proposal with \code{scale = 1}.}

\item{shape}{(optional) Numeric. shape parameter of the Pareto Distribution. Defaults to \code{NULL}, which implies a scalable proposal with \code{shape = 1}.}

\item{xl}{Numeric. Left truncation bound for the target distribution. Defaults to \code{-Inf}, representing no left truncation.}

\item{xr}{Numeric. Right truncation bound for the target distribution. Defaults to \code{Inf}, representing no right truncation.}

\item{steps}{(optional) Integer. Desired number of steps in the proposal. Defaults to \code{NULL}, which means the number of steps is determined automatically during optimization.}

\item{proposal_range}{(optional) Numeric vector. Specifies the range for optimizing the steps part of the proposal. Defaults to \code{NULL}, indicating automatic range selection.}

\item{theta}{Numeric. A parameter for proposal optimization. Defaults to 0.1.}

\item{target_sample_size}{(optional) Integer. Target sample size for proposal optimization. Defaults to \code{1000}.}

\item{verbose}{Boolean. If \code{TRUE}, detailed optimization information, including areas and steps, will be displayed. Defaults to \code{FALSE}.}
}
\value{
The user does not need to store the returned value, because the package internally cashes the proposal. However, we explain here the full returned proposal for advanced users.

A list containing the optimized proposal and related parameters for the specified built-in distribution:
#' \describe{
\item{\code{data}}{Detailed information about the proposal steps, including \code{x}, \code{s_upper}, \code{p_a}, and \code{s_upper_lower}.}
\item{\code{areas}}{The areas under the left tail, steps, and right tail of the proposal distribution.}
\item{\code{steps_number}}{The number of steps in the proposal.}
\item{\code{f_params}}{The parameters (\code{scale} and \code{shape}) of the Beta distribution.}
}
}
\description{
The \code{srpareto_optimize()} function generates an optimized proposal for a targeted Pareto Distribution.
The proposal can be customized and adjusted based on various options provided by the user.
}
\details{
When \code{srpareto_optimize()} is explicitly called:
\itemize{
\item A proposal is created and cached. If no parameters are provided, a standard proposal is created with \code{rate = 1}.
\item Providing \code{rate} creates a custom proposal, which is cached for use with \code{srpareto_custom()}.
\item The optimization process can be controlled via parameters such as \code{steps}, \code{proposal_range}, or
\code{theta}. If no parameters are provided, the proposal is optimized via brute force based on the.
\code{target_sample_size}.
}
}
\examples{
# Generate scalable proposal that with rate = 1, that has 4096 steps
scalable_proposal <- srpareto_optimize(steps = 4096)

# Generate custom proposal that with scale = 4
scalable_proposal <- srpareto_optimize(scale = 4)

}
\seealso{
\code{\link{srpareto_custom}}: Function to sample from a custom proposal tailored to user specifications.
}
