% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parlperiod_mps.R
\name{get_parlperiod_mps}
\alias{get_parlperiod_mps}
\title{Get list of MPs in a given parliamentary period}
\usage{
get_parlperiod_mps(periodid = NA, substitute = FALSE, good_manners = 0)
}
\arguments{
\item{periodid}{Character string indicating the id of the parliamentary period to retrieve.}

\item{substitute}{Logical. Whether or not to include substitute MPs.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{death} \tab Date of death \cr
   \strong{lastname} \tab MP last name \cr
   \strong{birth} \tab Date of birth \cr
   \strong{firstname} \tab MP first name \cr
   \strong{mp_id} \tab MP id \cr
   \strong{gender} \tab MP gender \cr
   \strong{county_id} \tab Id of county MP represented \cr
   \strong{party_id} \tab Id of party MP represented \cr
   \strong{substitute_mp} \tab Logical for whether MP is a substitute \cr
   \strong{period_id} \tab Id of period represented in \cr
}
}
\description{
A function for retrieving Norwegian MPs for a given parliamentary period from the parliament API
}
\examples{

\dontrun{

# Request one MP by id
get_parlperiod_mps("2005-2009")

# Request MPs from several periods by id
ids <- c("1961-65", "1997-01", "2009-2013")
mps <- lapply(ids, get_parlperiod_mps, good_manners = 2)
mps <- do.call(rbind, mps)

}

}
\seealso{
\link{get_mp_bio} \link{get_mp} \link{get_mp_pic} \link{get_session_mp_speech_activity}
}
