% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtp.R
\name{gtp}
\alias{gtp}
\title{Global temporal pattern (GTP)}
\usage{
gtp(start_date, trend = "stable",
slope = NULL, shortTerm = "cyclical",
fPeak = 90, show.plot =FALSE)
}
\arguments{
\item{start_date}{the start date of the temporal pattern.
The date should be in the format \code{"yyyy-mm-dd"}.
The GTP will normally cover a 1-year period.}

\item{trend}{specifies the direction of the
long-term trend. Options are:
\code{"falling"}, \code{"stable"},
and \code{"rising"}. Default value is: \code{"stable"}.}

\item{slope}{slope of the long-term trend when
an \code{"rising"} or \code{"falling"} trend is specified.
Options: \code{"gentle"} or \code{"steep"}. The default value is
set as \code{NULL} for the \code{stable} trend.}

\item{shortTerm}{type of short- to medium-term
fluctuations (patterns) of the time series.
Options are: \code{`"cyclical"` and `"acyclical"`}.
Default is: \code{`"cyclical"`}.}

\item{fPeak}{first seasonal
peak of cyclical short term. Default value is \code{90}.
Set as \code{NULL} for \code{"acyclical"} short term pattern.}

\item{show.plot}{(logical) Shows 'gtp'.
Default is \code{FALSE}.}
}
\value{
Returns a time series (list) of 365
data points representing
1-year global temporal pattern.
}
\description{
Models the global temporal pattern,
as combining the long-term trend and seasonality.
}
\details{
Models the GTP for anchoring the temporal
trends and patterns of the point patterns to be simulated.
}
\examples{
gtp(start_date = "2020-01-01", trend = "stable",
slope = NULL, shortTerm = "cyclical",
fPeak = 90, show.plot = FALSE)
}
