% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifiedyh.R
\name{stratified_custom_labels}
\alias{stratified_custom_labels}
\title{Stratify and Assign Custom Labels to Data}
\usage{
stratified_custom_labels(df, group_col, label_percentage, label1, label2)
}
\arguments{
\item{df}{A data frame to be stratified.}

\item{group_col}{A character string specifying the column name to group by.}

\item{label_percentage}{A numeric value between 0 and 100 indicating the percentage of the first label to assign within each group.}

\item{label1}{A character string representing the first label.}

\item{label2}{A character string representing the second label.}
}
\value{
A data frame with an additional column "Custom_Labels" containing the stratified custom labels.
}
\description{
This function stratifies data based on a specified grouping column and assigns custom labels according to a given percentage.
}
\examples{
result <- stratified_custom_labels(iris, group_col = "Species",
                                   label_percentage = 50,
                                   label1 = "High", label2 = "Low")
}
