% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_streamkm.R
\name{DSC_StreamKM}
\alias{DSC_StreamKM}
\alias{streamkm}
\alias{StreamKM}
\title{streamKM++}
\usage{
DSC_StreamKM(sizeCoreset = 10000, numClusters = 5, length = 100000L, ...)
}
\arguments{
\item{sizeCoreset}{Size of the coreset}

\item{numClusters}{Number of clusters to compute}

\item{length}{Length of the data stream}

\item{...}{Further arguments ignored.}
}
\description{
This is an interface to the MOA implementation of streamKM++.
}
\details{
streamKM++ uses a tree-based sampling strategy to obtain a small weighted sample of the stream
called coreset. The MOA implementation applies the k-means++ algorithm to find a given number
of centers in the coreset.

\strong{Notes:}
\itemize{
\item The cluster can only cluster the number of points specified in \code{length} ans then
produces an \code{ArrayIndexOutOfBoundsException} error.
\item The coreset (micro-clusters are not accessible), only the macro-clusters can be requested.
}
}
\examples{
set.seed(1000)
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# cluster with streamKM++
streamkm <- DSC_StreamKM(sizeCoreset = 100, numClusters = 3, length = 1000)
update(streamkm, stream, 100)
streamkm

# plot macro-clusters (no access to micro-clusters)
plot(streamkm, stream)
}
\references{
Marcel R. Ackermann, Christiane Lammersen, Marcus Maertens, Christoph Raupach,
Christian Sohler, Kamil Swierkot.
StreamKM++: A Clustering Algorithm for Data Streams. In: \emph{Proceedings of the 12th Workshop on Algorithm
Engineering and Experiments (ALENEX '10)}, 2010.
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_CluStream}()},
\code{\link{DSC_ClusTree}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_DenStream}()},
\code{\link{DSC_MCOD}()},
\code{\link{DSC_MOA}()}
}
\author{
Matthias Carnein
}
\concept{DSC_MOA}
