% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning.R
\name{thinning}
\alias{thinning}
\title{Thinning Algorithm for Models with Predict Function}
\usage{
thinning(
  model,
  data,
  max = 0.95,
  min = 0.05,
  iter = 0.05,
  classification = FALSE
)
}
\arguments{
\item{model}{A model that is currently of class type "reg_sine", "reg_asym",
"lm", or "mlm_stressor".}

\item{data}{A data frame with all the data.}

\item{max}{A numeric value in (0, 1] and greater than `min`,
defaulted to .95.}

\item{min}{A numeric value in (0, 1) and less than `max`, defaulted to .05.}

\item{iter}{A numeric value to indicate the step size, defaulted to .05.}

\item{classification}{A Boolean value defaulted `FALSE`, used for
`mlm_classification`.}
}
\value{
A list of objects, where the first element is the RMSE values at each
  iteration and the second element is the predictions.
}
\description{
Fits various train size and test sizes.
}
\examples{
 lm_data <- data_gen_lm(1000)
 lm_model <- lm(Y ~ ., lm_data)
 thin_results <- thinning(lm_model, lm_data)
}
