% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancor_eof.R
\name{cancor_eof}
\alias{cancor_eof}
\alias{cancor_eof.data.frame}
\alias{cancor_eof.stars}
\alias{autoplot.cancoreof}
\title{Performs CCA  using Empirical Orthogonal Functions (EOFs) from a lagged dataset}
\usage{
cancor_eof(x, lag, n_eof, ...)

\method{cancor_eof}{data.frame}(x, lag = 7, n_eof = 10, values_df, ...)

\method{cancor_eof}{stars}(x, lag = 7, n_eof = 10, ...)

\method{autoplot}{cancoreof}(
  object,
  line_plot = TRUE,
  space_plot = TRUE,
  palette = "Spectral",
  xlab = "Time",
  ...
)
}
\arguments{
\item{x}{The dataframe or stars object. If it is a dataframe, then it should have the locations.}

\item{lag}{Specifies the lag to be used.}

\item{n_eof}{The number of EOFs to be used.}

\item{...}{Other arguments currently ignored.}

\item{values_df}{For dataframes: the dataframe of dimension \code{length(times) x length(locations)} containing the quantity of interest.}

\item{object}{autoplot parameter: the output of the function `cancor_eof'.}

\item{line_plot}{autoplot parameter: if set to \code{TRUE}, then the line plot is included.}

\item{space_plot}{autoplot parameter: if set to \code{TRUE}, the space splot is included.}

\item{palette}{autoplot parameter: the color palette to use for plotting.}

\item{xlab}{autoplot parameter:: he label on the x-axis for the line plot.}
}
\value{
A cancoreof object with CCA output, EOF output, original data and cancor object from `stats`.
}
\description{
Performs Canonical Correlation Analysis (CCA) using Empirical Orthogonal Function analysis using
in a dataframe or a stars object. The autoplot function can plot the outputs.

The variations are
 *  `cancor_eof.data.frame()`  if the input is a dataframe
 *  `cancor_eof.stars()` if the input is a stars object
 *  `autoplot.cancoreof()` to plot the outputs.
}
\examples{
# Dataframe example
data(SSTlonlatshort)
data(SSTdatashort)
cancor_df <- cancor_eof(x = SSTlonlatshort,
           lag = 7,
           n_eof = 8,
           values_df = SSTdatashort)
autoplot(cancor_df)

# Stars example
library(dplyr)
library(stars)
# Create a stars object from a data frame
precip_df <- NOAA_df_1990[NOAA_df_1990$proc == 'Precip', ] \%>\%
  filter(date >= "1992-02-01" & date <= "1992-02-28")
precip <- precip_df[ ,c('lat', 'lon', 'date', 'z')]
st_precip <- st_as_stars(precip, dims = c("lon", "lat", "date"))
cancor_st <- cancor_eof(st_precip)
autoplot(cancor_st, line_plot = TRUE, space_plot = FALSE)


}
