% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fapply.R
\name{fapply}
\alias{fapply}
\title{Apply Formulas to a Model}
\usage{
fapply(formulas, model, ...)
}
\arguments{
\item{formulas}{a list of formulas or objects coercible to formula by
\link[stats:as.formula]{stats::as.formula}.}

\item{model}{a function taking a \code{\link[stats:formula]{formula}} as its first
argument.}

\item{...}{additional arguments to be passed to \code{model}.}
}
\value{
\code{fapply} returns a list of evaluated function calls.
}
\description{
\code{fapply} returns a list of the same length as \code{formulas}. Each element is
the result of applying \code{model}the the corresponding element of \code{formulas}.
}
\details{
This is a member of the \code{\link[base:lapply]{apply}} family. It is similar to
\code{\link[base:lapply]{lapply}}, but handles the \code{\link[base:call]{call}} slightly
differently. This makes the output prettier.
}
\examples{
formulas = subformula(mpg ~ cyl + disp, protected = ~ cyl)
fapply(formulas, lm, data = mtcars) # Pretty output.
lapply(formulas, lm, data = mtcars) # Less pretty output.
}
