% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pasta.R
\name{pasta}
\alias{pasta}
\title{pasta for multi-phenotype analysis}
\usage{
pasta(p.values, study.sizes, cor)
}
\arguments{
\item{p.values}{The p.value of each study.}

\item{study.sizes}{The sample size of each study.}

\item{cor}{The correlation matrix of the studies. For example, if each study
is independent, \code{cor} would be the identity matrix.}
}
\value{
A list containing the joint p value and the test statistic, which
  contains the optimal subset.
}
\description{
Search for the subset that yields the strongest evidence of
association and calculate the meta-analytic p-value, possibly in the
presence of gene-environmental interaction.
}
\examples{
# grab synthetic study for example
data("studies")
n.studies <- 5
study.sizes <- c(nrow(studies[[1]]), nrow(studies[[2]]), nrow(studies[[3]]),
                   nrow(studies[[4]]), nrow(studies[[5]]))
study.pvals <- rep(0, n.studies)
# Correlations of p-values among the studies.
# In this case the studies were generated independently so its just I
cor.matrix <- diag(1, n.studies)
# load the lrtest() function to conduct the likelihood ratio test
# Used just to generate the input p-values, not required in pasta itself.

library(lmtest)

for(i in 1:n.studies) {
 # model with gene(G) by environment(E) interaction
 model <- glm(D ~ G + E + GbyE, data = studies[[i]], family = binomial)
 # model without G and GE interaction
 null.model <- glm(D ~ E, data = studies[[i]], family = binomial)
 # likelihood ratio test from the package lmtest
 study.pvals[i] = lmtest::lrtest(null.model, model)[2, 5]
}

pasta <- pasta(study.pvals, study.sizes, cor.matrix)

pasta$p.pasta
pasta$test.statistic$selected.subset
}
\references{
Yu Y, Xia L, Lee S, Zhou X, Stringham H, M, Boehnke M, Mukherjee
  B: Subset-Based Analysis Using Gene-Environment Interactions for Discovery
  of Genetic Associations across Multiple Studies or Phenotypes. Hum Hered
  2019. doi: 10.1159/000496867
}
