% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{set_default_settings}
\alias{set_default_settings}
\title{Settings functionality for package 'sumup'}
\usage{
set_default_settings()
}
\value{
A list containing all settings used in 'sumup'
}
\description{
This file contains helper functions used throughout package 'sumup' to set and update the settings of the algorithm.

Create a list of settings for the algorithms in 'sumup'
}
\author{
Joyce M.W. Moonen - van Loon

This file defines  functions used to set and update the settings used in the 'sumup' algorithms
Functions in this file:
\itemize{
\item set_default_settings(): Set the default settings list of the package (optimized for a Dutch Master in Medicine education using CanMeds competencies and professional activities)
\item update_educational_framework_settings(settings): Update settings related to the educational framework
\item update_setting(settings, setting_name, new_value): Updates setting 'setting_name' with value 'new_value', returning the new list of settings
\item check_all_settings(settings): Check whether all settings are of the correct type and fit the required ranges
\item check_setting(settings, setting_name, setting_value):  Check whether setting_value is allowed for setting 'setting_name'
}

Usage:
Load this package and call the functions directly.

Note: This file is part of the 'sumup' package.
}
