% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.resid}
\alias{autoplot.resid}
\alias{autoplot.clm}
\alias{autoplot.glm}
\alias{autoplot.lrm}
\alias{autoplot.orm}
\alias{autoplot.polr}
\alias{autoplot.vgam}
\alias{autoplot.vglm}
\title{Residual Plots for Cumulative Link and General Regression Models}
\usage{
autoplot.resid(object, what = c("qq", "fitted", "covariate"), x = NULL,
  fit = NULL, distribution = qnorm, alpha = 1, xlab = NULL,
  color = "#444444", shape = 19, size = 2, qqpoint.color = "#444444",
  qqpoint.shape = 19, qqpoint.size = 2, qqline.color = "#888888",
  qqline.linetype = "dashed", qqline.size = 1, smooth = TRUE,
  smooth.color = "red", smooth.linetype = 1, smooth.size = 1,
  fill = NULL, ...)

autoplot.clm(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.glm(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.lrm(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.orm(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.polr(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.vgam(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)

autoplot.vglm(object, what = c("qq", "fitted", "covariate"), x = NULL,
  alpha = 1, xlab = NULL, color = "#444444", shape = 19, size = 2,
  qqpoint.color = "#444444", qqpoint.shape = 19, qqpoint.size = 2,
  qqline.color = "#888888", qqline.linetype = "dashed", qqline.size = 1,
  smooth = TRUE, smooth.color = "red", smooth.linetype = 1,
  smooth.size = 1, fill = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link[ordinal]{clm}},
\code{\link[stats]{glm}}, \code{\link[rms]{lrm}}, \code{\link[rms]{orm}},
\code{\link[MASS]{polr}}, or \code{\link[VGAM]{vglm}}.}

\item{what}{Character string specifying what to plot. Default is \code{"qq"}
which produces a quantile-quantile plots of the residuals.}

\item{x}{A vector giving the covariate values to use for residual-by-
covariate plots (i.e., when \code{what = "covariate"}).}

\item{fit}{The fitted model from which the residuals were extracted. (Only
required if \code{what = "fitted"} and \code{object} inherits from class
\code{"resid"}.)}

\item{distribution}{Function that computes the quantiles for the reference
distribution to use in the quantile-quantile plot. Default is \code{qnorm}
which is only appropriate for models using a probit link function. When
\code{jitter.scale = "probability"}, the reference distribution is always
U(-0.5, 0.5). (Only
required if \code{object} inherits from class \code{"resid"}.)}

\item{alpha}{A single values in the interval [0, 1] controlling the opacity
alpha of the plotted points. Only used when \code{nsim} > 1.}

\item{xlab}{Character string giving the text to use for the x-axis label in
residual-by-covariate plots. Default is \code{NULL}.}

\item{color}{Character string or integer specifying what color to use for the
points in the residual vs fitted value/covariate plot.
Default is \code{"black"}.}

\item{shape}{Integer or single character specifying a symbol to be used for
plotting the points in the residual vs fitted value/covariate plot.}

\item{size}{Numeric value specifying the size to use for the points in the
residual vs fitted value/covariate plot.}

\item{qqpoint.color}{Character string or integer specifying what color to use
for the points in the quantile-quantile plot.}

\item{qqpoint.shape}{Integer or single character specifying a symbol to be
used for plotting the points in the quantile-quantile plot.}

\item{qqpoint.size}{Numeric value specifying the size to use for the points
in the quantile-quantile plot.}

\item{qqline.color}{Character string or integer specifying what color to use
for the points in the quantile-quantile plot.}

\item{qqline.linetype}{Integer or character string (e.g., \code{"dashed"})
specifying the type of line to use in the quantile-quantile plot.}

\item{qqline.size}{Numeric value specifying the thickness of the line in the
quantile-quantile plot.}

\item{smooth}{Logical indicating whether or not too add a nonparametric
smooth to certain plots. Default is \code{TRUE}.}

\item{smooth.color}{Character string or integer specifying what color to use
for the nonparametric smooth.}

\item{smooth.linetype}{Integer or character string (e.g., \code{"dashed"})
specifying the type of line to use for the nonparametric smooth.}

\item{smooth.size}{Numeric value specifying the thickness of the line for the
nonparametric smooth.}

\item{fill}{Character string or integer specifying the color to use to fill
the boxplots for residual-by-covariate plots when \code{x} is of class
\code{"factor"}. Default is \code{NULL} which colors the boxplots according
to the factor levels.}

\item{...}{Additional optional arguments to be passed onto
\code{\link[sure]{resids}}.}
}
\value{
A \code{"ggplot"} object.
}
\description{
Residual-based diagnostic plots for cumulative link and general regression
models using \code{\link[ggplot2]{ggplot2}} graphics.
}
\examples{
# See ?resids for an example
?resids
}
