% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv2sample-ver003.R
\name{rmstreg}
\alias{rmstreg}
\title{Adjusted difference/ratio of restricted mean survival times}
\usage{
rmstreg(y, delta, x, arm, tau, type="difference", conf.int=0.95)
}
\arguments{
\item{y}{The follow-up time.}

\item{delta}{The censoring indicator, 1=event, and 0=censoring.}

\item{x}{The covariate matrix. The first colomn of this matrix should be the group indicator, arm (below).}

\item{arm}{The group indicator, 1/0.}

\item{tau}{The value indicates the restricted time point on the follow-up time to calculate the restricted mean survival time.}

\item{type}{The type of the between-group contrast measure: "difference"(default), "ratio" or "lossratio".}

\item{conf.int}{The level for computation of the confidence intervals. The default is 0.95.}
}
\description{
Compares restricted mean survival time between two groups, adjusting for imbalance of baseline factors via a regression model.
}
\examples{
D=pbc.sample()
x=cbind(D$group, D$covariates)
rmstreg(D$time, D$status, x, D$group, tau=8, type="difference")
}
\references{
Tian L, Zhao L, Wei LJ. Predicting the restricted mean event time with the subject's baseline covariates in survival analysis. Biostatistics 2014, 15, 222-233.
}
\author{
Lu Tian
}
