% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confIntArea.R
\name{confIntArea}
\alias{confIntArea}
\title{Adds a confident interval area of a survival model to a plot.}
\usage{
confIntArea(x, group, event, col = "grey", invert = FALSE)
}
\arguments{
\item{x}{A survfit (survival-package) or a Cuminc (mstate-package) object.}

\item{group}{Number of the group (=strata) of which the confidence interval 
should be plotted. If the survfit-object has only one strata, this
parameter can be omitted.}

\item{event}{If the model-object is a multistate-model, the number of the
event-type needs to be specified.}

\item{col}{Color of the confident interval area. Default is "grey". A
transparent value is recommended, for example "adjustcolor("red",0.1).}

\item{invert}{Inverts the area if TRUE, default is FALSE.}
}
\value{
Draws an area for the confidence interval.
}
\description{
This function adds the confident interval area of one group (strata) of
a survfit object to an existing plot. For competitive risk models, it
draws the confidence interval of one group and one event; the event-number
needs to be specified. If two overlapping confidence intervals are drawn 
(by two function calls) in one plot, the use of transparent color is
recommended, for example "adjustcolor("red",0.1).
}
\examples{
  require(survival)
  aml_model <- with(aml, survfit(Surv(time, status)~x))
  col1 <- adjustcolor("red",0.2); col2 <- adjustcolor("blue",0.2)
  survPlot(xmax=50, space.nrAtRisk=0.32)
  confIntArea(aml_model, col=col1, group=1)
  confIntArea(aml_model, col=col2, group=2)
  survCurve(aml_model, group=1)
  survCurve(aml_model, group=2, lty=2)
  nrAtRisk(aml_model, group=1, y=-0.17, bgcol.flag=col1, label="maintain")
  nrAtRisk(aml_model, group=2, y=-0.24, bgcol.flag=col2, lty.flag=2, label="non-maint.")
}
