% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst2perm.sample.data.R
\name{rmst2perm.sample.data}
\alias{rmst2perm.sample.data}
\title{Sample Dataset from Ovarian Data}
\usage{
rmst2perm.sample.data(t.unit="month")
}
\arguments{
\item{t.unit}{Specify the time unit. It supports \code{"month"} (default) and \code{"day"}.}
}
\value{
returns a data frame
}
\description{
Generates a sample dataset of 26 randomized patients from the ovarian data.
}
\details{
The function creates a sample dataset to illustrate the usage of the function \code{rmst2perm()} in this package.
This function loads the ovarian data from the survival package, deriving three variables.
The variables in the dataset are as follows: \code{time}, survival time in months;
\code{status}, event indicator (0=censor, 1=event); \code{arm}, treatment arm (0=cyclophosphamide, 1=cyclophosphamide+adriamycin).
}
\examples{
D = rmst2perm.sample.data()
head(D)
}
\references{
Collett, D. Modelling Survival Data in Medical Research. Chapman and Hall/CRC. 2015; page 213.

Edmonson JH, Fleming TR, Decker DG, et al. Different chemotherapeutic sensitivities and host factors affecting prognosis in
advanced ovarian carcinoma versus minimal residual disease. Cancer Treat Rep. 1979;63(2):241-247.
}
\seealso{
\code{ovarian} in survival package
}
