% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{mean.survextrap}
\alias{mean.survextrap}
\title{Mean survival time}
\usage{
\method{mean}{survextrap}(
  x,
  newdata = NULL,
  newdata0 = NULL,
  wane_period = NULL,
  wane_nt = 10,
  disc_rate = 0,
  niter = NULL,
  summ_fns = NULL,
  sample = FALSE,
  ...
)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{newdata}{Data frame of covariate values to compute the output for.
If there are covariates in the model and this is not supplied,
the following default is used:

(a) if the only covariate is one factor variable, then the output is computed
for each level of this factor.

(b) if there are multiple covariates, or any numeric covariates, then the output
is computed at the mean of each numeric covariate in the original data, and at the
baseline level of each factor covariate.

Note: caution is required about how treatment groups (for example)
are stored in your data.  If these are coded as numeric (0/1),
then if \code{newdata} is not specified, only one output will be shown.
This relates to the average value of this numeric variable over
the data, which doesn't correspond to either of the treatment
groups.  To avoid this, a treatment group should be stored as a
factor.}

\item{newdata0}{Data frame of covariate values defining the "untreated" group
for use in treatment waning models. See \code{\link{Survmspline_wane}}.}

\item{wane_period}{Vector of two numbers, defining the time period over which
the hazard is interpolated between the hazard of the "treated" group (taken from \code{newdata})
and the hazard of the "untreated" group (taken from \code{newdata0}).  Optional - if
this is not supplied, then no waning is assumed.}

\item{wane_nt}{Number of intervals defining the piecewise constant approximation
to the hazard during the waning period.}

\item{disc_rate}{Discounting rate used to calculate the discounted mean
or restricted mean survival time, using an exponential discounting function.}

\item{niter}{Number of MCMC iterations to use to compute credible
intervals.  Set to a low value to make this function quicker, at the cost of
some approximation error (which may not be important for plotting or model
development).}

\item{summ_fns}{A list of functions to use to summarise the posterior sample.
This is passed to \code{\link[posterior:summarise_draws]{posterior::summarise_draws}}.
By default this is \code{list(median=median, ~quantile(.x, probs=c(0.025, 0.975)))}.
If the list is named, then the names will be used for the columns of the
output.}

\item{sample}{If \code{TRUE} then an MCMC sample is returned from the posterior
of the output, rather than summary statistics.}

\item{...}{Other options (currently unused).}
}
\value{
A data frame with each row containing posterior summary statistics
for a particular covariate value.

An attribute \code{"sample"} is also returned, containing a matrix
of samples from the posterior distribution of the RMST.
}
\description{
Compute the mean survival time from a model fitted with
\code{\link{survextrap}}.  Defined as the integral of the fitted
survival curve from zero to infinity.  This relies on numerical
integration, which is done for every parameter in the MCMC sample,
so it may be slow.
}
\details{
Additionally for some models, the integration up to infinity may
not converge, giving an error message.  This typically occurs if
there is a substantial probability of high survival times or zero
hazards at later times.  The restricted mean survival time can
usually be computed in these situations with \code{\link{rmst}},
but the model should also be investigated to ensure the posterior
distributions are realistic, and simplified or supplemented with
external data or informative priors if appropriate.
}
