% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggPopulation.R
\name{aggPopulation}
\alias{aggPopulation}
\title{Get population information}
\usage{
aggPopulation(tiff, fact = 10, poly.adm, by.adm, by.adm.upper = NULL)
}
\arguments{
\item{tiff}{spatial raster of population estimates.}

\item{fact}{factor to aggregate pixels. Default to be 10, i.e., the population estimates will be saved on 1km by 1km grids if the input is 100m by 100m tiff. Larger values of aggregation factor improves the computation speed, but can introduce more errors when the regions defined by the polygon are small in size.}

\item{poly.adm}{spatial polygons dataframe.}

\item{by.adm}{the column name of column for Admin names for desired output Admin level, can be such as "NAME_1" or "NAME_2".}

\item{by.adm.upper}{the column name of column for Admin names for upper level of your desired output Admin level when admin=2, can be "NAME_1" when by.adm="NAME_2".}
}
\value{
This function returns the dataset that contain district name and population for given  tiff files and polygons of admin level
}
\description{
This function aggregate population to particular admin levels
}
\examples{
\dontrun{
library(raster)

# Download and find total population in age group 0 to 12 months
pre <- "https://data.worldpop.org/GIS/AgeSex_structures/"
f <- paste0(pre, "Global_2000_2020/2018/ZMB/zmb_f_0_2018.tif")
m <- paste0(pre, "Global_2000_2020/2018/ZMB/zmb_m_0_2018.tif")
pop_f_0 <- raster(f)
pop_m_0 <- raster(m)

pop_raster <- pop_f_0 + pop_m_0

# admin1 population
agg.pop1 <- aggPopulation(
  tiff = pop_raster,
  poly.adm = ZambiaAdm1,
  by.adm = "NAME_1")


# admin2 population
agg.pop2 <- aggPopulation(
  tiff = ZambiaPopWomen_raster,
  poly.adm = ZambiaAdm2,
  by.adm = "NAME_2",
  by.adm.upper="NAME_1")

}

}
\author{
Qianyu Dong
}
