% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix_table}
\alias{matrix_table}
\title{Create a table of frequencies and counts for matrix questions}
\usage{
matrix_table(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE,
  column_order = NULL
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}

\item{column_order}{reorder columns of final table with an argument to pass to \code{dplyr::relocate()}}
}
\value{
A gt table summarizing percentages and counts for each response
option in the specified multiple-choice question. If grouping is provided,
the table includes subgroups and is formatted for clarity.

@examples
#Array question (1-5)
matrix_table(berlinbears, dplyr::starts_with('p_'))

#Use \code{group_by} to partition the question into several groups
matrix_table(berlinbears, dplyr::starts_with('p_'), group_by = species,
subgroups_to_exclude = 'panda bear' )

#Remove NA category
matrix_table(berlinbears, dplyr::starts_with('p_'), group_by = species,
subgroups_to_exclude = 'panda bear', na.rm = TRUE

#Categorical input
matrix_table(berlinbears, dplyr::starts_with('c_'), group_by = is_parent)
}
\description{
This function creates a table showing percentages and counts for each
response option in a multiple-choice question, specified by \code{question}. If
grouping is provided with \code{group_by}, the table is extended to include
subgroups. Subgroups can be excluded, and survey weights are supported for
adjusted counts. The table is formatted for clarity and can be displayed in
wide format. When weights are used, counts are presented as percentages only,
and a note is added at the bottom of the table.
}
\seealso{
Other matrix questions: 
\code{\link{matrix_freq}()},
\code{\link{matrix_likert}()},
\code{\link{matrix_mean}()}
}
\concept{matrix questions}
