% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveynnet.R
\name{surveynnet}
\alias{surveynnet}
\title{Neural Net for Complex Survey Data}
\usage{
surveynnet(x, y, weight, strat, clust, comp_cases = FALSE, ...)
}
\arguments{
\item{x}{Matrix or data frame of predictors. Must not contain any missing values.}

\item{y}{Vector of targets / response values. Must not contain any missing values.}

\item{weight}{The weights for each sample.}

\item{strat}{The stratum for each sample.}

\item{clust}{The cluster for each sample.}

\item{comp_cases}{If TRUE, filter out missing values from x, y, weight, strat, and clust. Default FALSE.
Note that in either case, the dimensions of all data mentioned above must agree.}

\item{...}{Additional arguments to be passed into \code{PracTools::deffCR} or \code{nnet::nnet}. See
documentation of those packages and functions for more details. Note that for the neural net (\code{nnet}),
the default here is set to 3 layers ("size" parameter) and maximum iterations ("maxit" parameter) is
set to 2000.}
}
\value{
A list containing two objects:
\itemize{
\item A dataframe with the fitted values of the neural nets, using:
no weights ("fitted"), the user-inputted weights ("fitted_weighted"), and the new method that adjusts the weights by using a design
effect incorporating cluster and strata ("fitted_deff").
\item The fitted neural network object (from \code{nnet}), using the novel design-effect based weights; this
can be used to predict the outcomes for new observations.
}
}
\description{
The surveynnet package extends the functionality of nnet (Venables and Ripley, 2002),
which already supports survey weights, by enabling it to handle clustered and stratified data.
It achieves this by incorporating design effects through the use of effective sample sizes in
the calculations, performed by the package described in Valliant et al. (2023), by following
the methods outlined by Chen and Rust (2017) and Valliant et al. (2018).
}
\examples{

# short example with body fat dataset
y <- body_fat$pct_body_fat
x <- body_fat[,c("Weight_kg", "Height_cm", "Age")]
weight <- body_fat$survey_wt
strat <- body_fat$stratum
clust <- body_fat$cluster
y[strat==1] <- y[strat==1] + 30*0.00015*rnorm(sum(strat==1))
y[strat==2] <- y[strat==2] + 30*0.15*rnorm(sum(strat==2))

myout <- surveynnet(x,y,weight = weight, strat = strat, clust=clust)
myout


# NHANES example
# Predicting Diastolic BP from BMI, Systolic BP and Height
# PLEASE NOTE: for this example, pass "nest=TRUE" into the
# "..." parameters of the main function `surveynnet`

x <- nhanes.demo[,c("BMXBMI", "BPXSY1", "BMXHT")]
weight <- nhanes.demo$WTMEC2YR
strat <- nhanes.demo$SDMVSTRA
clust <- nhanes.demo$SDMVPSU
y <- nhanes.demo$BPXDI1
myout <- surveynnet(x,y,weight = weight, strat = strat, clust=clust, nest=TRUE)
head(myout$results, 15)

}
\references{
\itemize{
\item Chen, S., and K. F. Rust. 2017."An Extension of Kish’s Formula for Design Effects to
Two- and Three-Stage Designs with Stratification.”, Journal of Survey Statistics and
Methodology,5 (2): 111–30.
\item Valliant, R., J. A. Dever, and F. Kreuter. 2018. Practical Tools for Designing
and Weighting Survey Samples .2nd ed. New York: Springer-Verlag.
}
}
