% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survm_effectsize.R
\name{survm_effectsize}
\alias{survm_effectsize}
\title{Effect size calculation for mixture survival distributions}
\usage{
survm_effectsize(
  ascale0_r,
  ascale0_nr,
  delta_p,
  p0,
  bshape0 = 1,
  bshape1 = 1,
  ascale1_r,
  ascale1_nr,
  tau,
  Delta_r = NULL,
  Delta_0 = NULL,
  Delta_nr = NULL,
  anticipated_effects = FALSE
)
}
\arguments{
\item{ascale0_r}{scale parameter for the Weibull distribution in the control group for responders}

\item{ascale0_nr}{scale parameter for the Weibull distribution in the control group for non-responders}

\item{delta_p}{effect size for the response rate}

\item{p0}{event rate for the response}

\item{bshape0}{shape parameter for the Weibull distribution in the control group}

\item{bshape1}{shape parameter for the Weibull distribution in the intervention group}

\item{ascale1_r}{scale parameter for the Weibull distribution in the intervention group for responders}

\item{ascale1_nr}{scale parameter for the Weibull distribution in the intervention group for non-responders}

\item{tau}{follow-up}

\item{Delta_r}{RMST difference between intervention and control groups for responders}

\item{Delta_0}{RMST difference between responders and non-responders in the control group}

\item{Delta_nr}{RMST difference between intervention and control groups for non-responders}

\item{anticipated_effects}{Logical parameter. If it is TRUE then the effect size is computed based on previous information on the effect sizes on response rate and survival-by-responses (that is, based on Delta_r, Delta_0, Delta_nr); otherwise is based on the distributional parameters (ascale0_r, ascale0_nr, ascale1_r, ascale1_nr, bshape0, bshape1).}
}
\value{
This function returns the overall mean survival improvement (RMST difference between groups) and  it also includes the mean survival improvement that would be assumed for each responders and non-responders.
}
\description{
The function `survm_effectsize` calculates the effect size in terms of the difference of restricted mean survival times (RMST) according to the information on responders and non-responders.
}
\examples{
survm_effectsize(ascale0_r=8,ascale0_nr=5.6,ascale1_r=36,ascale1_nr=5.6,delta_p=0.2,p0=0.2,tau=5)
}
\references{
Design of phase III trials with long-term survival outcomes based on short-term binary results. Marta Bofill Roig, Yu Shen, Guadalupe Gomez Melis. 	arXiv:2008.12887
}
\author{
Marta Bofill Roig.
}
