% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisk_multiuni.R
\name{crisk_multiuni}
\alias{crisk_multiuni}
\title{Modify the Output for Multiple Uni-variable Competing Risk Analysis .}
\usage{
crisk_multiuni(
  dat,
  csurv,
  cevent,
  catvars = NULL,
  convars = NULL,
  ordvars = NULL,
  y1 = TRUE,
  y2 = TRUE,
  y5 = TRUE,
  month = 0
)
}
\arguments{
\item{dat}{a data.frame in which to interpret the variables.}

\item{csurv}{this is the follow up time.}

\item{cevent}{the status indicator, normally 0=alive, 1=dead.}

\item{catvars}{a vector of cat variable names.}

\item{convars}{a vector of con variable names.}

\item{ordvars}{a vector of ordinal variable names.}

\item{y1}{logical value indicating whether the 1-year competing risk rate should be reported.}

\item{y2}{logical value indicating whether the 2-year competing risk rate should be reported.}

\item{y5}{logical value indicating whether the 5-year competing risk rate should be reported.}

\item{month}{a number to get the month-rate of competing risk.}
}
\value{
a tibble of competing risk analysis output.
}
\description{
This function generates a table of competing risk analysis result with number of patients, number of event, number of competing event,
}
\examples{
Dat <- MASS::Melanoma
Dat$time <- Dat$time/30.5
Dat$ulcer <- as.factor(Dat$ulcer)
con_var <- c("age")
ord_var <- c("ulcer")
cat_var <- c("sex")
uni_out <- crisk_multiuni(Dat, "time", "status",cat_var, con_var, ord_var)
}
