% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELBO.R
\name{elbo}
\alias{elbo}
\title{Calculates the variational Bayes convergence criteria, evidence lower
bound (ELBO), optimized in \code{survregVB.fit}.}
\usage{
elbo(
  y,
  X,
  delta,
  alpha_0,
  omega_0,
  mu_0,
  v_0,
  alpha,
  omega,
  mu,
  Sigma,
  expectation_b
)
}
\arguments{
\item{y}{A vector of observed log-transformed survival times.}

\item{X}{A design matrix including covariates with first column of ones
to represent the intercept.}

\item{delta}{A binary vector indicating right censoring.}

\item{alpha_0}{The shape hyperparameter \eqn{\alpha_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{omega_0}{The shape hyperparameter \eqn{\omega_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{mu_0}{Hyperparameter \eqn{\mu_0}, a vector of means, of the prior
distribution of the vector of coefficients, \eqn{\beta}.}

\item{v_0}{The precision (inverse variance) hyperparameter \eqn{v_0},
of the prior distribution of the vector of coefficients, \eqn{\beta}.}

\item{alpha}{The shape parameter \eqn{\alpha^*} of \eqn{q^*(b)}.}

\item{omega}{The scale parameter \eqn{\omega^*} of \eqn{q^*(b)}.}

\item{mu}{Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}, a vector of means.}

\item{Sigma}{Parameter \eqn{\Sigma^*} of \eqn{q^*(\beta)}, a covariance
matrix.}

\item{expectation_b}{The expected value of \emph{b}.}
}
\description{
Calculates the variational Bayes convergence criteria, evidence lower
bound (ELBO), optimized in \code{survregVB.fit}.
}
\seealso{
\code{\link{survregVB.fit}}
}
