% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{mu_star}
\alias{mu_star}
\title{Calculates parameter \eqn{\mu^*} of \eqn{q^*(\beta)} to optimize the
evidence based lower bound (ELBO) in \code{survregVB.fit}.}
\usage{
mu_star(y, X, delta, mu_0, v_0, alpha, omega, mu, Sigma, expectation_b)
}
\arguments{
\item{y}{A vector of observed log-transformed survival times.}

\item{X}{A design matrix including covariates with first column of ones
to represent the intercept.}

\item{delta}{A binary vector indicating right censoring.}

\item{mu_0}{Hyperparameter \eqn{\mu_0}, a vector of means, of the prior
distribution of the vector of coefficients, \eqn{\beta}.}

\item{v_0}{The precision (inverse variance) hyperparameter \eqn{v_0},
of the prior distribution of the vector of coefficients, \eqn{\beta}.}

\item{alpha}{The shape parameter \eqn{\alpha^*} of \eqn{q^*(b)}.}

\item{omega}{The scale parameter \eqn{\omega^*} of \eqn{q^*(b)}.}

\item{mu}{Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}, a vector of means.}

\item{Sigma}{Parameter \eqn{\Sigma^*} of \eqn{q^*(\beta)}, a covariance
matrix.}

\item{expectation_b}{The expected value of \emph{b}.}
}
\value{
Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}.
}
\description{
Calculates parameter \eqn{\mu^*} of \eqn{q^*(\beta)} to optimize the
evidence based lower bound (ELBO) in \code{survregVB.fit}.
}
\seealso{
\code{\link{survregVB.fit}}
}
