% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survregVB.fit.R
\name{survregVB.fit}
\alias{survregVB.fit}
\title{Variational Bayesian Analysis of Survival Data Using a Log-Logistic
Accelerated Failure Time Model}
\usage{
survregVB.fit(
  Y,
  X,
  alpha_0,
  omega_0,
  mu_0,
  v_0,
  max_iteration = 100,
  threshold = 1e-04
)
}
\arguments{
\item{Y}{A \code{Surv} object containing 2 columns: time and event.}

\item{X}{A design matrix including covariates with first column of ones
to represent the intercept.}

\item{alpha_0}{The shape hyperparameter \eqn{\alpha_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{omega_0}{The shape hyperparameter \eqn{\omega_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{mu_0}{Hyperparameter \eqn{\mu_0}, a vector of means, of the prior
distribution of the vector of coefficients, \eqn{\beta}.}

\item{v_0}{The precision (inverse variance) hyperparameter \eqn{v_0},
of the prior distribution of the vector of coefficients, \eqn{\beta}.}

\item{max_iteration}{The maximum number of iterations for the variational
inference optimization. If reached, iteration stops. (Default:100)}

\item{threshold}{The convergence threshold for the evidence based lower
bound (ELBO) optimization. If the difference between the current and
previous ELBO's is smaller than this threshold, iteration stops.
(Default:0.0001)}
}
\value{
A list containing results of the fit.
}
\description{
Called by \code{survregVB} to do the actual parameter and ELBO
computations. This routine does no checking that the arguments are the
proper length or type.
}
\details{
Implements the Variational Bayes algorithm proposed in the paper "Variational
Bayesian analysis of survival data using a log-logistic accelerated failure
time model."

For right-censored survival time \eqn{T_i} of the \eqn{i_{th}} subject
in a sample, \eqn{i=1,...,n}, the log-logistic AFT model is specified
as follows:

\eqn{\log(T_i)=X_i^T\beta+bz_i}, where
\itemize{
\item \eqn{X_i} is a column vector of length \eqn{p, p\ge2} containing
\eqn{p-1} covariates and a constant one to incorporate the intercept
(i.e., \eqn{X_i=(1,x_{i1},...,x_{i(p-1)})^T}),
\item \eqn{\beta} is the corresponding vector of coefficients for the fixed
effects,
\item \eqn{z_i} is a random variable following a standard logistic
distribution, and
\item \emph{b} is a scale parameter.
}
}
\examples{
fit <- survregVB.fit(
  Y = survival::Surv(simulation_nofrailty$Time, simulation_nofrailty$delta),
  X = matrix(c(rep(1, 300), simulation_nofrailty$x1, simulation_nofrailty$x2), nrow = 300),
  alpha_0 = 11,
  omega_0 = 10,
  mu_0 = c(0, 0, 0),
  v_0 = 1
)

}
\references{
Xian, C., Souza, C. P. E. de, He, W., Rodrigues, F. F.,
& Tian, R. (2024). "Variational Bayesian analysis of survival data
using a log-logistic accelerated failure time model." Statistics and
Computing, 34(2). https://doi.org/10.1007/s11222-023-10365-6
}
\seealso{
\code{\link{survregVB}}
}
