% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_assignments.R
\name{suso_gql_assignments}
\alias{suso_gql_assignments}
\title{Get all assignments}
\usage{
suso_gql_assignments(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  archived = FALSE,
  id = NULL,
  questionnaireId = NULL,
  version = NULL,
  responsibleId = NULL,
  webMode = FALSE,
  take = NULL,
  skip = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{API password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{archived}{Boolean if the assignment is archived or not}

\item{id}{Assignment ID}

\item{questionnaireId}{Questionnaire ID}

\item{version}{Questionnaire version}

\item{responsibleId}{ID of the person currently responsible for the assignment}

\item{webMode}{Boolean for webmode}

\item{take}{take the specified integer numeber of assignments}

\item{skip}{skip the first integer number of assignments}
}
\value{
if successfull, returns a list with the (filtered) responses
}
\description{
Allows the user to retrieve filtered or unfiltered assignment data.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Get all assignments without filter

suso_gql_assignments(endpoint = ep, user = usr,
password = pass, workspace = ws)

# Select assignment with id 25
suso_gql_assignments(endpoint = ep, user = usr,
password = pass, workspace = ws, id = 25)

# Select assignment excluding id 25, by using susoop_numeric
suso_gql_assignments(endpoint = ep, user = usr,
password = pass, workspace = ws, id = susoop_num$neq(25))

\dontshow{\}) # examplesIf}
}
