% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_mapreport.R
\name{suso_gql_mapreport}
\alias{suso_gql_mapreport}
\title{Get the map report}
\usage{
suso_gql_mapreport(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  questionnaireId = NULL,
  questionnaireVersion = NULL,
  variable = NULL,
  zoom = 1,
  clientMapWidth = 0,
  west = -180,
  east = 180,
  north = 90,
  south = -90,
  assignmentId = NULL,
  clientKey = NULL,
  createdDate = NULL,
  errorsCount = NULL,
  identifyingData = NULL,
  interviewMode = NULL,
  notAnsweredCount = NULL,
  questionnaireVariable = NULL,
  responsibleName = NULL,
  responsibleRole = NULL,
  status = NULL,
  supervisorName = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{API password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{questionnaireId}{the questionnnaire id}

\item{questionnaireVersion}{the questionnaire version}

\item{variable}{Variable(s) of interest}

\item{zoom}{Zoom of the map report}

\item{clientMapWidth}{width of the client map}

\item{west}{coordinates for bounding box}

\item{east}{coordinates for bounding box}

\item{north}{coordinates for bounding box}

\item{south}{coordinates for bounding box}

\item{assignmentId}{Assignment ID}

\item{clientKey}{Interview key}

\item{createdDate}{Creation data of the interview}

\item{errorsCount}{number of errors}

\item{identifyingData}{Pre-loaded identifying data}

\item{interviewMode}{Interview mode (CAWI or CAPI)}

\item{notAnsweredCount}{number of unanswered questions}

\item{questionnaireVariable}{the variable for the questionnaire}

\item{responsibleName}{Name of the person responsible}

\item{responsibleRole}{Role of the person responsible}

\item{status}{of the interview}

\item{supervisorName}{Name of the supervisor of the responsible user}
}
\value{
if successfull, returns a list with the (filtered) responses
}
\description{
Allows the user to retrieve filtered or unfiltered map report data.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

questlist<-suso_gql_questionnaires(
    endpoint = ep, user = usr,
    password = pass,
    workspace = "primary")

id<-questlist$questionnaires$nodes$questionnaireId[1]
 v<-questlist$questionnaires$nodes$version[1]

# Get map report for GPS question start_location

suso_gql_mapreport(endpoint = ep, user = usr,
password = pass, workspace = ws,
questionnaireId = id, questionnaireVersion = v, variable = "start_location")

\dontshow{\}) # examplesIf}
}
