% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_questionnaireItems.R
\name{suso_gql_questionnaireitems}
\alias{suso_gql_questionnaireitems}
\title{Get all Questions in a Questionnaires}
\usage{
suso_gql_questionnaireitems(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  id = NULL,
  version = NULL,
  variable = NULL,
  scope = NULL,
  identifying = NULL,
  title = NULL,
  includedInReportingAtUtc = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{API password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{id}{Questionnaire ID}

\item{version}{Questionnaire version}

\item{variable}{Get questions for a specific variable}

\item{scope}{Get questions for a specific scope}

\item{identifying}{If TRUE only identifying questions are exported}

\item{title}{the text of the questions}

\item{includedInReportingAtUtc}{time of the last reporting}
}
\value{
if successfull, returns a list with the (filtered) responses
}
\description{
Allows the user to retrieve all questions in a questionniare.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

questlist<-suso_gql_questionnaires(
    endpoint = ep, user = usr,
    password = pass,
    workspace = "primary")

id<-questlist$questionnaires$nodes$questionnaireId[1]
v<-questlist$questionnaires$nodes$version[1]

# Get all questions from a questionnaire/version without filter

suso_gql_questionnaireitems(endpoint = ep, user = usr,
     password = pass,
     workspace = ws,
     id = id,
     version = v)

# Select only identifying questions
suso_gql_questionnaireitems(endpoint = ep, user = usr,
     password = pass,
     workspace = ws,
     id = id,
     version = v,
     identifying = TRUE)

# Select only questions which have not interviewer scope
suso_gql_questionnaireitems(endpoint = ep, user = usr,
      password = pass,
      workspace = ws,
      id = id,
      version = v,
      scope = susoop_str$neq("INTERVIEWER"))
\dontshow{\}) # examplesIf}
}
