% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_users.R
\name{suso_gql_users}
\alias{suso_gql_users}
\title{Get user information}
\usage{
suso_gql_users(
  endpoint = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  userName = NULL,
  fullName = NULL,
  isArchived = NULL,
  isLocked = NULL,
  creationDate = NULL,
  email = NULL,
  phoneNumber = NULL,
  id = NULL,
  role = NULL,
  sortby_userName = NULL,
  sortby_role = NULL,
  sortby_creationDate = NULL,
  take = NULL,
  skip = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{user}{your API username}

\item{password}{API password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{userName}{specific user name}

\item{fullName}{fullName}

\item{isArchived}{isArchived}

\item{isLocked}{isLocked}

\item{creationDate}{user creation date}

\item{email}{user email}

\item{phoneNumber}{user phoneNumber}

\item{id}{user id}

\item{role}{user role}

\item{sortby_userName}{sort users by user name, either ASC for ascending or DESC for descending}

\item{sortby_role}{sort users by role, either ASC for ascending or DESC for descending}

\item{sortby_creationDate}{sort users by utc creation date, either ASC for ascending or DESC for descending}

\item{take}{take the specified integer numeber of maps}

\item{skip}{skip the first integer number of maps}
}
\value{
if successfull, returns a list with the (filtered) responses
}
\description{
Allows the user to retrieve filtered or unfiltered user data.
}
\details{
ATTENTION: This requires admin credentials, regular API credentials won't work
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and ADMIN credentials!!

# Get all users without filter

suso_gql_users(endpoint = ep, user = adminuser,
password = adminpass, sortby_userName = "ASC")

# Get only supervisors

suso_gql_users(endpoint = ep, user = adminuser,
password = adminuser, , sortby_userName = "ASC",
role = "SUPERVISOR")
\dontshow{\}) # examplesIf}
}
