% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_message.R
\name{dlg_message}
\alias{dlg_message}
\alias{dlgMessage}
\alias{msg_box}
\alias{msgBox}
\alias{ok_cancel_box}
\alias{okCancelBox}
\alias{dlg_message.gui}
\alias{dlg_message.textCLI}
\alias{dlg_message.nativeGUI}
\title{Display a modal message box.}
\usage{
dlg_message(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  ...,
  gui = .GUI
)

dlgMessage(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  ...,
  gui = .GUI
)

msg_box(message)

msgBox(message)

ok_cancel_box(message)

okCancelBox(message)

\method{dlg_message}{gui}(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  ...,
  gui = .GUI
)

\method{dlg_message}{textCLI}(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  ...,
  gui = .GUI
)

\method{dlg_message}{nativeGUI}(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  rstudio = getOption("svDialogs.rstudio", TRUE),
  ...,
  gui = .GUI
)
}
\arguments{
\item{message}{The message to display in the dialog box. Use \verb{\\\\n} for line
break, or provide a vector of character strings, one for each line (except under RStudio where it is not possible to force line break inside the message string).}

\item{type}{The type of dialog box: \code{'ok'}, \code{'okcancel'}, \code{'yesno'} or
\code{'yesnocancel'}.}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}

\item{rstudio}{Logical. Should 'RStudio' dialog boxes automatically be used
if available? If \code{FALSE}, force using OS dialog boxes, but only in
'RStudio Desktop' (ignored in 'RStudio Server'). Can be changed globally
with \code{options(svDialogs.rstudio = TRUE|FALSE)}. \code{TRUE} by default.}
}
\value{
The modified 'gui' object is returned invisibly. A string with the
name of the button (\code{"ok"}, \code{"cancel"}, \code{"yes"} or \code{"no"}) that the user
pressed can be obtained from \code{gui$res} (see example).
\code{msg_box()} just returns the name of the button (\code{"ok"}), while
\code{ok_cancel_box()} returns \code{TRUE} if "ok" was clicked or \code{FALSE} if "cancel"
was clicked.
}
\description{
A message box with icon, text, and one to three buttons.
}
\note{
On 'RStudio' or with 'zenity' under Linux, only two buttons are
available. So, when using \code{type = "yesnocancel"}, two successive dialog boxes
are displayed: one with the message and \code{'yes'}/\code{'no'} buttons, and a second
one asking to continue, and if the user clicks \code{'no'}, the function returns
\code{"cancel"}. This is clearly sub-optimal. So, for a clean experience on all
supported platforms, try to avoid \code{'yesnocancel'} as much as possible.
}
\examples{
\dontrun{
# A simple information box
dlg_message("Hello world!")$res

# Ask to continue
dlg_message(c("This is a long task!", "Continue?"), "okcancel")$res

# Ask a question
dlg_message("Do you like apples?", "yesno")$res

# Idem, but one can interrupt too
res <- dlg_message("Do you like oranges?", "yesnocancel")$res
if (res == "cancel")
  cat("Ah, ah! You refuse to answer!\n")

# Simpler version with msgBox and okCancelBox
msg_box("Information message") # Use this to interrupt script and inform user
if (ok_cancel_box("Continue?")) cat("we continue\n") else cat("stop it!\n")
}
}
\seealso{
\code{\link[=dlg_list]{dlg_list()}}, \code{\link[=dlg_input]{dlg_input()}}
}
\concept{Modal dialog box}
\keyword{misc}
