% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Svplot1fg.R
\name{svplot1}
\alias{svplot1}
\title{Creates Sv-plot1, the first version of the sample variance plots.}
\usage{
svplot1(X,title="Sv-plot1",xlab="x",lbcol="grey5",lscol="grey60",
              rbcol="grey45",rscol="grey75",...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is number of observations.}

\item{title}{title of the plot, \emph{Sv-plot1} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lbcol}{left bound color, \emph{grey5} by default.}

\item{lscol}{left square color, \emph{grey60} by default.}

\item{rbcol}{right bound color, \emph{grey45} by default.}

\item{rscol}{right square color, \emph{grey75} by default.}

\item{...}{other graphical parameters.}
}
\value{
Sv-plot1
}
\description{
Sv-plot1 identifies the characteristics of the distribution illustrating  squared deviations in the sample variance by squares for each data value.
}
\examples{
   set.seed(0)
   X1 <- matrix(rnorm(50,mean=2,sd=5))
   svplot1(X1)

   X2 <- matrix(rf(50,df1=10,df2=5))
   svplot1(X2)

   X3 <- matrix(rbeta(50,shape1=10,shape2=2))
   svplot1(X3,title="",lbcol="blue",lscol="blue",rbcol="red",rscol="grey75")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
