% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestOneMufg.R
\name{test1mu}
\alias{test1mu}
\title{Tests the hypothesis over population mean based on one sample by Sv-plot2.}
\usage{
test1mu(X,mu0=3.5,alpha=0.05,unkwnsigma=TRUE,sigma=NULL,xlab="x",
               title="Single mean: Hypothesis testing by Sv-plot2",
               samcol="grey5",popcol="grey45",thrcol="black",...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is number of observations.}

\item{mu0}{hypothesized population mean, \emph{mu0=3.5} by default.}

\item{alpha}{significance level, \emph{alpha=0.05} by default.}

\item{unkwnsigma}{population standard deviation is unknown, \emph{TRUE} by default.}

\item{sigma}{population standard deviation, \emph{NULL} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{title}{title of the plot, \emph{Single mean: Hypothesis testing by Sv-plot2} by default.}

\item{samcol}{sample Sv-plot2 color, \emph{grey5} by default.}

\item{popcol}{sample Sv-plot2 color, \emph{grey45} by default.}

\item{thrcol}{threshold color, \emph{black} by default.}

\item{...}{other graphical parameters.}
}
\value{
Decision on testing hypotheses over single population mean by Sv-plot2.
}
\description{
Decision on hypothesis testing over single mean is made by graphing sample and population Sv-plot2s along with the threshold line. If the intersection point of two Sv-plot2s locates on or above the threshold line, the null hypothesis is rejected at specified significance level, otherwise, failed to reject.
}
\examples{
   set.seed(5)
   X=matrix(rnorm(20,mean=3,sd=2))
   test1mu(X,mu0=3.5,alpha=0.05,unkwnsigma=TRUE,sigma=NULL,xlab="x",
           title="Single mean: Hypothesis testing by Sv-plot2",
           samcol="grey5",popcol="grey45",thrcol="black")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
