% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestTwoMufg.R
\name{test2mu}
\alias{test2mu}
\title{Tests the hypothesis over two population means based on two samples by Sv-plot2.}
\usage{
test2mu(X1,X2,paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
               sigma1=NULL,sigma2=NULL,alpha=0.05,xlab="x",
               title="Two means: Hypothesis testing by Sv-plot2",
               sam1col="grey5",sam2col="grey45",thrcol="black",...)
}
\arguments{
\item{X1}{an \eqn{n1} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n1}, where \eqn{n1} is number of observations.}

\item{X2}{an \eqn{n2} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n2}, where \eqn{n2} is number of observations.}

\item{paired}{for dependent samples TRUE, \emph{FALSE} by default.}

\item{eqlvar}{population variances are equal, \emph{FALSE} by default.}

\item{unkwnsigmas}{population standard deviations are unknown, \emph{TRUE} by default.}

\item{sigma1}{population1  standard deviation, \emph{NULL} by default.}

\item{sigma2}{population2  standard deviation, \emph{NULL} by default.}

\item{alpha}{significance level, \emph{alpha=0.05} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{title}{title of the plot, \emph{Two means: Hypothesis testing by Sv-plot2} by default.}

\item{sam1col}{sample1 Sv-plot2 color, \emph{grey5} by default.}

\item{sam2col}{sample2 Sv-plot2 color, \emph{grey45} by default.}

\item{thrcol}{threshold color, \emph{black} by default.}

\item{...}{other graphical parameters.}
}
\value{
Decision on testing hypotheses over two population means by Sv-plot2.
}
\description{
Decision on hypothesis testing over two means is made by graphing two sample Sv-plot2s along with the threshold line. If the intersection point of two Sv-plot2s locates on or above the threshold line, the null hypothesis is rejected at specified significance level, otherwise, failed to reject.
}
\examples{
set.seed(5)
test2mu(X1=matrix(rnorm(10,mean=3,sd=2)),X2=matrix(rnorm(20,mean=4,sd=2.5)),
       paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
       sigma1=NULL,sigma2=NULL,alpha=0.05,
       sam1col="grey5",sam2col="grey45",thrcol="black")

test2mu(X1=matrix(rnorm(10,mean=3,sd=2)),X2=matrix(rnorm(20,mean=4,sd=2.5)),
       paired=FALSE,eqlvar=TRUE,unkwnsigmas=TRUE,
       sigma1=NULL,sigma2=NULL,alpha=0.05,
       sam1col="grey5",sam2col="grey45",thrcol="black")

test2mu(X1=matrix(rnorm(50,mean=3,sd=2)),X2=matrix(rnorm(30,mean=4,sd=2.5)),
       xlab="x",title="Two means: Hypothesis testing by Sv-plot2",
       paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
       sigma1=NULL,sigma2=NULL,alpha=0.05,
       sam1col="grey5",sam2col="grey45",thrcol="black")

test2mu(X1=matrix(rnorm(50,mean=3,sd=2)),X2=matrix(rnorm(30,mean=4,sd=2.5)),
       paired=FALSE,eqlvar=FALSE,unkwnsigmas=FALSE,
       sigma1=2,sigma2=4.920782,alpha=0.05,
       sam1col="grey5",sam2col="grey45",thrcol="black")

X1=matrix(rnorm(10,mean=3,sd=2))
X2=2*X1
test2mu(X1,X2,
       paired=TRUE,eqlvar=FALSE,unkwnsigmas=TRUE,
       sigma1=NULL,sigma2=NULL,alpha=0.05,
       sam1col="blue",sam2col="red",thrcol="black")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
