% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wroc.R
\name{wroc}
\alias{wroc}
\title{Estimation of the ROC curve of logistic regression models with complex survey data}
\usage{
wroc(
  response.var,
  phat.var,
  weights.var = NULL,
  tag.event = NULL,
  tag.nonevent = NULL,
  data = NULL,
  design = NULL,
  cutoff.method = NULL
)
}
\arguments{
\item{response.var}{A character string with the name of the column indicating the response variable in the data set
or a vector (either numeric or character string) with information of the response variable for all the units.}

\item{phat.var}{A character string with the name of the column indicating the estimated probabilities in the data set
or a numeric vector containing estimated probabilities for all the units.}

\item{weights.var}{A character string indicating the name of the column with sampling weights or
a numeric vector containing information of the sampling weights.
It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.
For unweighted estimates, set all the sampling weight values to 1.}

\item{tag.event}{A character string indicating the label used to indicate the event of interest in \code{response.var}.
The default option is \code{tag.event = NULL}, which selects the class with the lowest number of units as event.}

\item{tag.nonevent}{A character string indicating the label used for non-event in \code{response.var}.
The default option is \code{tag.nonevent = NULL}, which selects the class with the greatest number of units as non-event.}

\item{data}{A data frame which, at least, must incorporate information on the columns
\code{response.var}, \code{phat.var} and \code{weights.var}.
If \code{data=NULL}, then specific numerical vectors must be included in
\code{response.var}, \code{phat.var} and \code{weights.var},
or the sampling design should be indicated in the argument \code{design}.}

\item{design}{An object of class \code{survey.design} generated by
\code{survey::svydesign} indicating the complex sampling design of the data.
If \code{design = NULL}, information on the data set (argument \code{data})
and/or sampling weights (argument \code{weights.var}) must be included.}

\item{cutoff.method}{A character string indicating the method to be used to select the optimal cut-off point.
If \code{cutoff.method = NULL}, then no optimal cut-off point is calculated.
If an optimal cut-off point is to be calculated, one of the following methods needs to be selected:
\code{Youden}, \code{MaxProdSpSe}, \code{ROC01}, \code{MaxEfficiency}.}
}
\value{
The output object of this function is a list of class \code{wroc}, which contains information about the weighted ROC curve of a logistic regression model and some of its components. In particular, this list contains a total of 5 or 6 elements (depending on the selected arguments) with the following information:
\itemize{
\item \code{wroc.curve}: this element is a list that contains three numerical vectors. Specifically,
\itemize{
\item \code{Sew.values}: a vector of all the different values for the weighted estimate of the sensitivity across all the possible cut-off points.
\item \code{Spw.values}: a vector of all the different values for the weighted estimate of the specificity across all the possible cut-off points.
\item \code{cutoffs}: this vector contains all the cut-off points that have been considered to estimate sensitivity and specificity parameters.
}
\item \code{wauc}: a numeric value indicating the area under the weighted estimate of the ROC curve.
\item \code{optimal.cutoff}: if the argument \code{cutoff.method != NULL}, this object is a list containing the 4 elements described below:
\itemize{
\item \code{method}: character string indicating the method implemented to calculate the optimal cut-off point.
\item \code{cutoff.value}: the optimal cut-off point value.
\item \code{Spw}: the weighted estimate of the specificity for the optimal cut-off point value (indicated in \code{cutoff.value}).
\item \code{Sew}: the weighted estimate of the sensitivity for the optimal cut-off point value (indicated in \code{cutoff.value}).
}
\item \code{tags}: a list containing two elements with the following information:
\itemize{
\item \code{tag.event}: a character string indicating the event of interest.
\item \code{tag.nonevent}: a character string indicating the non-event.
}
\item \code{basics}: a list containing information of the following 4 elements:
\itemize{
\item \code{n.event}: number of units with the event of interest in the data set.
\item \code{n.nonevent}: number of units without the event of interest in the data set.
\item \code{hatN.event}: number of units with the event of interest represented in the population by all the event units in the data set, i.e., the sum of the sampling weights of the units with the event of interest in the data set.
\item \code{hatN.nonevent}: a numeric value indicating the number of non-event units in the population represented by means of the non-event units in the data set, i.e., the sum of the sampling weights of the non-event units in the data set.
}
\item \code{call}: an object saving the information about the way in which the function has been run.
}
}
\description{
Calculate the ROC curve of a logistic regression model
considering sampling weights with complex survey data
}
\details{
\eqn{S} indicate a sample of \eqn{n} observations of the vector of random variables \eqn{(Y,\pmb X)}, and \eqn{\forall i=1,\ldots,n,} \eqn{y_i} indicate the \eqn{i^{th}} observation of the response variable \eqn{Y},
and \eqn{\pmb x_i} the observations of the vector covariates \eqn{\pmb X}. Let \eqn{w_i} indicate the sampling weight corresponding to the unit \eqn{i} and \eqn{\hat p_i} the estimated probability of event.
Let \eqn{S_0} and \eqn{S_1} be subsamples of \eqn{S}, formed by the units without the event of interest (\eqn{y_i=0}) and with the event of interest (\eqn{y_i=1}), respectively.
Then, the ROC curve is estimated as follows:
\deqn{\widehat{ROC}_w(\cdot)=\{(1-\widehat{Sp}_w(c),\widehat{Se}_w(c)),\:c\in (-\infty, \infty)\}},
where, the sensitivity and specificity parameters for a given cut-off point \eqn{c} are estimated as follows:
\deqn{\widehat{Se}_w(c)=\dfrac{\sum_{i\in S_1}w_i\cdot I (\hat p_i\geq c)}{\sum_{i\in S_1}w_i}\:;\:\widehat{Sp}_w(c)=\dfrac{\sum_{i\in S_0}w_i\cdot I (\hat p_i<c)}{\sum_{i\in S_0}w_i}.}

See Iparragirre et al (2023) for more information. More information of the rest of the elements is given in the documentation of the functions \code{wauc()} and \code{wocp()}.
}
\examples{
data(example_data_wroc)

mycurve <- wroc(response.var = "y", phat.var = "phat", weights.var = "weights",
                data = example_data_wroc,
                tag.event = 1, tag.nonevent = 0,
                cutoff.method = "Youden")

# Or equivalently
\donttest{
mycurve <- wroc(response.var = example_data_wroc$y,
                phat.var = example_data_wroc$phat,
                weights.var = example_data_wroc$weights,
                tag.event = 1, tag.nonevent = 0,
                cutoff.method = "Youden")
}
}
\references{
Iparragirre, A., Barrio, I. and Arostegui, I. (2023).
Estimation of the ROC curve and the area under it with complex survey data.
\emph{Stat} \strong{12}(1), e635. (https://doi.org/10.1002/sta4.635)
}
