% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heading.R
\name{ang_speed}
\alias{ang_speed}
\alias{angSpeed}
\title{Angular Speeds}
\usage{
ang_speed(x, y, t, geo = FALSE)

angSpeed(x, y, t, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates corresponding to a single 
trajectory.}

\item{y}{A vector of y (or latitude) coordinates corresponding to a single 
trajectory.}

\item{t}{A vector of timestamps corresponding to a single trajectory.}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A vector of the same length as x, y and t corresponding to the 
 approximated instantaneous angular speeds along the trajectory.
}
\description{
Given a set of locations defining a trajectory, this function 
 approximates their instantaneous instantaneous angular speeds computed as 
 the difference between successive headings divided by the time between these 
 successive headings.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
t <- as.POSIXct(1:25, origin = Sys.time())
ang_speed(x, y, t)

}
\seealso{
\code{\link{heading}}, \code{\link{ang_acc}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
