% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{centroid}
\alias{centroid}
\title{Centroid}
\usage{
centroid(x, y, robust = FALSE, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{robust}{A logical value indicating whether to compute the centroid as a
simple average of the coordinates (FALSE, the default), or as the average of 
the coordinates weighted by the inverse of their mean pairwise distance to 
all other coordinates in the set (TRUE).}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A two-element list corresponding to the location of the centroid.
}
\description{
This function computes the centroid (or center of mass) of a set 
 of x-y (or longitude-latitude) coordinates.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
centroid(x, y)

}
\seealso{
\code{\link{dist2centroid}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
