% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R, R/orders.R
\name{.cartesianPerimeter}
\alias{.cartesianPerimeter}
\alias{rot_order}
\alias{rotOrder}
\title{Rotational Order Parameter}
\usage{
.cartesianPerimeter(x, y)

rot_order(x, y, h)

rotOrder(h, x, y)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{h}{A vector of headings (in radians).}
}
\value{
A single value between 0 and 1 corresponding to the rotational 
 order parameter of the group.
}
\description{
Given a set of headings and locations, this function returns the 
 rotational order of the set
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
h <- runif(25, 0, 2 * pi)
rot_order(x, y, h)

}
\seealso{
\code{\link{pol_order}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
