% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.hyph.support.R
\name{set.hyph.support}
\alias{set.hyph.support}
\title{Add support for new languages}
\usage{
set.hyph.support(value)
}
\arguments{
\item{value}{A named list that upholds exactly the structure defined above.}
}
\description{
You can use this function to add new languages to be used with \code{sylly}.
}
\details{
Language support in this package is designed to be extended easily. You could call it modular,
although it's actually more "environemntal", but nevermind.

To add new language support, say for Xyzedish, you basically have to call this function
once and provide respective hyphenation patterns. If you would like to re-use this language
support, you should consider making it a package.

If it succeeds,
      it will fill an internal environment with the information you have defined.
\code{hyphen} will then know which language patterns are available as data files (which
you must provide also). 

You provide the meta data as a named list. It usually has one single entry to tell the new language
abbreviation, e.g., \code{set.hyph.support(list("xyz"="xyz"))}. However,
      this will only work if a)
the language support script is a part of the \code{sylly} package itself,
      and b) the hyphen pattern
is located in its \code{data} subdirectory.

For your custom hyphenation patterns to be found automatically,
      provide it as the value in the named
list, e.g., \code{set.hyph.support(list("xyz"=hyph.xyz))}.
This will directly add the patterns to \code{sylly}'s environment,
      so it will be found when
hyphenation is requested for language \code{"xyz"}.

If you would like to provide hyphenation as part of a third party language package,
      you must name the
object \code{hyph.<lang>}, save it to your package's \code{data} subdirectory named
\code{hyph.<lang>.rda}, and append \code{package="<yourpackage>"} to the named list; e.g.,
\code{set.hyph.support(list("xyz"=c("xyz", package="koRpus.lang.xyz"))}. Only then
\code{sylly} will look for the pattern object in your package,
      not its own \code{data} directory.
}
\section{Hyphenation patterns}{


To be able to also do syllable count with the newly added language,
      you should add a hyphenation pattern
file as well.
Refer to the documentation of read.hyph.pat() to learn how to produce a pattern object from a downloaded
hyphenation pattern file. Make sure you use the correct name scheme (e.g. "hyph.xyz.rda") and good
compression.
}

\examples{
\dontrun{
set.hyph.support(
  list("xyz"="xyz")
)
}
}
