% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector.R
\name{Vector}
\alias{Vector}
\alias{V}
\title{Symbolic Vector}
\usage{
Vector(x, ...)

V(...)
}
\arguments{
\item{x, ...}{R objects.}
}
\value{
A \code{VecBasic}.
}
\description{
A symbolic vector is represented by \code{VecBasic} S4 class.
\code{Vector} and \code{V} are constructors of \code{VecBasic}.
}
\details{
There are some differences between \code{Vector} and \code{V}.
\itemize{
  \item{
    For double values, \code{V} will check whether they are
    whole number, and convert them to integer if so.
    \code{Vector} will not.
  }
  \item{
    \code{V} does not accept "non-scalar" arguments,
    like \code{Vector(c(1,2,3))}.
  }
}
}
\examples{
a <- S("a")
b <- S("b")
Vector(a, b, a + b, 42L)
Vector(list(a, b, 42L))

Vector(1,2,a)
V(1,2,a)
}
