% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparam.R
\name{impulseest}
\alias{impulseest}
\title{Estimate Impulse Response Coefficients}
\usage{
impulseest(x, M = 30, K = NULL, regul = F, lambda = 1)
}
\arguments{
\item{x}{an object of class \code{idframe}}

\item{M}{Order of the FIR Model (Default:\code{30})}

\item{K}{Transport delay in the estimated impulse response 
(Default:NULL)}

\item{regul}{Parameter indicating whether regularization should be 
used. (Default:\code{FALSE})}

\item{lambda}{The value of the regularization parameter. Valid only if
\code{regul=TRUE}. (Default:\code{1})}
}
\description{
\code{impulseest} is used to estimate impulse response coefficients from 
the data
}
\details{
The IR Coefficients are estimated using linear least squares. Future 
Versions will provide support for multivariate data.
}
\examples{
uk <- rnorm(1000,1)
yk <- filter (uk,c(0.9,-0.4),method="recursive") + rnorm(1000,1)
data <- idframe(output=data.frame(yk),input=data.frame(uk))
fit <- impulseest(data)
impulseplot(fit)

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 17.4.11 and 20.2
}
\seealso{
\code{\link{step}}
}

