% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExponentialFitnessLinkFun.R
\name{Model.fitness.genlambdaparprior}
\alias{Model.fitness.genlambdaparprior}
\title{Prior distribution for eta and zeta in the fitness model}
\usage{
Model.fitness.genlambdaparprior(
  shapemin = 0.75,
  shapemax = 1.5,
  ratescale,
  sdshapeprob = 0.1,
  sdpropscale = 0.1
)
}
\arguments{
\item{shapemin}{Minimal Value of the shape parameter. Default: 0.75.}

\item{shapemax}{Maximal Value of the shape parameter. Default: 1.5.}

\item{ratescale}{Rate parameter for the prior distribution of the scale parameter. In the model this is on the same scale as the entries of \code{L}}

\item{sdshapeprob}{Standard deviation for the additivel normally
distributed random walk proposal for the shape parameter. Defaults to 0.1.}

\item{sdpropscale}{Standard deviation for the multiplicative
lognormal proposals for the scale parameter.}
}
\value{
list of functions necessary for constructing
Metropolis-Hastings updates.
}
\description{
Assumes a uniform distribution on the shape parameter \code{zeta} and an
exponential distribution on the scale parameter \code{eta}. To be used
as prior for \code{\link{Model.additivelink.exponential.fitness}}.
}
